local configServer = require 'config.config_s'
local state = require 'server.state'
local editable = require 'config.server'

CreateThread(function()
    lib.print.info("Starting gym stats degradation thread")

    while true do
        Wait(60000)

        local players = GetPlayers()
        local updatedPlayers = 0

        for _, playerId in ipairs(players) do
            local source = tonumber(playerId)
            if source then
                editable.updateStats(source, {
                    condition = -(configServer.stats.decrease.condition or 0.001),
                    strength = -(configServer.stats.decrease.strength or 0.0005),
                })
            end
        end

        if updatedPlayers > 0 then
            lib.print.debug(string.format("Updated gym stats for %d players", updatedPlayers))
        end

        if configServer.exhaustion.enable then
            for source, groups in pairs(state.getAllExhaustion()) do
                for group, value in pairs(groups) do
                    if value > 0 then
                        state.setExhaustion(source, group, math.max(0, value - (configServer.exhaustion.recoveryRate or 0.01)))

                        local hasExhaustion = false
                        for _, v in pairs(groups) do
                            if v > 0 then
                                hasExhaustion = true
                                break
                            end
                        end
                        if not hasExhaustion then
                            state.clearExhaustion(source)
                        end
                    end
                end
            end
        end
    end
end)
