-- Server-side configuration for gym system mechanics
-- This file controls exhaustion, stat progression, and gameplay balance

return {
    debug = false, -- Enable debug logging for troubleshooting
    syncDistance = 50.0, -- Distance (in meters) for synchronizing equipment between players

    enableMinigame = false, -- Enable skill check minigame when starting exercises

    gymCreator = { -- /gymcreator command
        enable = true,
        restricted = 'group.admin', -- ox_lib's addCommand restriction string, set to false to disable restriction

        ---@param source number
        ---@return boolean
        canAccess = function(source)
            -- additional checks can be added here
            return true
        end
    },

    -- Exhaustion/fatigue system - prevents spam and adds realism
    exhaustion = {
        enable = false, -- Enable exhaustion system
        recoveryRate = 0.01, -- Recovery per minute (0.01 = 1% per minute)

        enableMuscleGroups = true, -- Enable separate exhaustion tracking per muscle group
        muscleGroups = { -- Muscle groups for targeted exhaustion trackingaustion tracking
            legs = { 'leg_press', 'gymbike' }, -- Leg exercises
            arms = { 'speedbag', 'gymspeedbag', 'gympullmachine1', 'gympullmachine2' }, -- Arm exercises
            back = { 'gymlatpull', 'gymrowpull' }, -- Back exercises
            core = { 'vin_chu' } -- Core/abs exercises
        },

        rates = { -- Exhaustion amount added per exercise completion (0-1 scale)
            vin_chu = 0.2,
            leg_press = 0.3,
            speedbag = 0.15,
            gymbike = 0.25,
            gymlatpull = 0.2,
            gympullmachine1 = 0.3,
            gympullmachine2 = 0.3,
            gymrowpull = 0.3,
            gymspeedbag = 0.3,
        }
    },

    -- Player stats progression system
    stats = {
        enable = true, -- Enable stat progression
        rates = { -- Stat gains per exercise completion (condition = cardio, strength = power)
            vin_chu = { condition = 0.05, strength = 0.03 },
            leg_press = { condition = 0.03, strength = 0.08 },
            speedbag = { condition = 0.06, strength = 0.04 },
            gymbike = { condition = 0.09, strength = 0.02 },
            gymlatpull = { condition = 0.04, strength = 0.07 },
            gympullmachine1 = { condition = 0.05, strength = 0.06 },
            gympullmachine2 = { condition = 0.05, strength = 0.06 },
            gymrowpull = { condition = 0.04, strength = 0.07 },
            gymspeedbag = { condition = 0.07, strength = 0.05 },
        },

        decrease = { -- Stat decay over time (creates need for regular training)
            condition = 0.001, -- Condition loss per minute (0.001 = 0.1% per minute)
            strength = 0.0005, -- Strength loss per minute (0.0005 = 0.05% per minute)
        }
    },
}