local client = {}

---@param title string The title of the notification
---@param message string The message content
---@param type? 'info' | 'success' | 'error' | 'warning' The type of notification
client.notify = function(title, message, type)
    lib.notify({
        title = title,
        description = message,
        type = type,
    })
end

---@param machine string The machine/equipment type being used
---@return boolean Returns true if the minigame was successful
client.minigame = function(machine)
    local success = lib.skillCheck({
        'easy',
        'easy',
    }, {'1', '2', '3', '4'})
    return success --[[@as boolean]]
end

---@param machine string The machine/equipment type
---@param repeatCount number Number of repetitions
---@param animSpeed number Animation playback speed
client.onExerciseStart = function(machine, repeatCount, animSpeed)
    LocalPlayer.state:set('invBusy', true, false)
    if GetResourceState('ox_target') == 'started' then
        exports.ox_target:disableTargeting(true)
    end
end

---@param machine string The machine/equipment type
client.onExerciseEnd = function(machine)
    LocalPlayer.state:set('invBusy', false, false)
    if GetResourceState('ox_target') == 'started' then
        exports.ox_target:disableTargeting(false)
    end
end

client.boxingRing = {
    -- Called when a boxing match starts
    onFightStart = function()
        LocalPlayer.state:set('invBusy', true, false)
    end,

    -- Called when a boxing match ends
    ---@param result string 'winner' | 'loser' | 'draw' The result of the match
    onFightEnd = function(result)
        LocalPlayer.state:set('invBusy', false, false)
    end
}

-- Updates player stats based on gym progress
-- Modifies running, swimming, stamina, and melee combat abilities
-- Each stat provides up to 50% bonus at 100 points
local function updateGymData(condition, strength)
    SetRunSprintMultiplierForPlayer(cache.playerId, 1.0 + (condition / 100) * 0.5)
    SetSwimMultiplierForPlayer(cache.playerId, 1.0 + (condition / 100) * 0.5)
    SetPlayerStamina(cache.playerId, 1.0 + (condition / 100) * 0.5)
    local strengthFactor = 1.0 + (strength / 100) * 0.5
    SetPlayerMeleeWeaponDamageModifier(cache.playerId, strengthFactor)
    SetPlayerMeleeWeaponDefenseModifier(cache.playerId, strengthFactor)
end

---@param data {condition?: number, strength?: number}
RegisterNetEvent('gym:updateGymData', function(data)
    lib.print.debug("Updating gym data - Condition: " .. tostring(data.condition) .. ", Strength: " .. tostring(data.strength) .. ")")
    updateGymData(data.condition or 0, data.strength or 0)
end)

return client