local config = require 'config.config_c'
local clientConfig = require 'config.client'
local ringCoords
lib.locale()

function openRingUI(entity)
    lib.print.debug(string.format("Player opening boxing ring UI at entity: %d", entity))

    local coords = GetEntityCoords(entity)
    local data, message = lib.callback.await('gym:getRingData', 500, coords)
    if not data then
        lib.print.warn(string.format("Failed to get ring data: %s", message or "unknown"))
        return clientConfig.notify(locale('error_title'), message or locale('error_unknown'), 'error')
    end

    ringCoords = coords
    lib.print.debug("Ring data retrieved successfully")
    SendNUIMessage({
        action = 'setRingData',
        data = data
    })
    SetNuiFocus(true, true)
end
exports('openRingUI', openRingUI)

if GetResourceState('ox_target') == 'started' then
    exports.ox_target:addModel(config.boxingRing.model, {
        {
            icon = 'fas fa-dumbbell',
            label = locale('ring_open'),
            onSelect = function(data)
                openRingUI(data.entity)
            end,
            canInteract = function(entity)
                local crds = GetEntityCoords(entity)
                for _, ringCrds in pairs(config.boxingRing.coords) do
                    if #(crds - vec3(ringCrds.x, ringCrds.y, ringCrds.z)) < 0.5 then
                        return true
                    end
                end

                return false
            end
        },
    })
else
    lib.print.error("ox_target not found or not started - boxing ring target will not be created")
end

RegisterNUICallback('closeRingUI', function()
    TriggerServerEvent('gym:closeRing')
    SetNuiFocus(false, false)
end)

RegisterNUICallback('ringReady', function(_, cb)
    local response = lib.callback.await('gym:ringReady', 300)
    cb(response)
end)

RegisterNUICallback('ringLeave', function(_, cb)
    local response = lib.callback.await('gym:ringLeave', 300)
    cb(response)
end)

RegisterNUICallback('ringJoin', function(_, cb)
    local response = lib.callback.await('gym:ringJoin', 300)
    cb(response)
end)

RegisterNetEvent('gym:updateRingData', function(data)
    SendNUIMessage({
        action = 'setRingData',
        data = data
    })
    if not data then
        SetNuiFocus(false, false)
    end
end)

RegisterNetEvent('gym:startFight', function(data)
    lib.print.info("Starting boxing fight - teleporting player to ring")

    local coords = data.coords
    local heading = data.heading
    SetNuiFocus(false, false)

    DoScreenFadeOut(500)
    Wait(500)
    SetCurrentPedWeapon(cache.ped, `WEAPON_UNARMED`, true)
    SetEntityCoordsNoOffset(cache.ped, coords.x, coords.y, coords.z, 0, 0, 0, false)
    SetEntityHeading(cache.ped, heading)
    lib.playAnim(cache.ped, 'anim@deathmatch_intros@unarmed', 'intro_male_unarmed_e')
    SetTimeout(4000, function()
        StopAnimTask(cache.ped, 'anim@deathmatch_intros@unarmed', 'intro_male_unarmed_e', 1.0)
    end)
    Wait(500)
    DoScreenFadeIn(500)
    if clientConfig.boxingRing.onFightStart then
        pcall(clientConfig.boxingRing.onFightStart)
    end
end)

RegisterNetEvent('gym:endFight', function(coords, health)
    lib.print.info("Ending boxing fight - returning player to original position")
    if health then
        SetEntityHealth(cache.ped, health)
    end

    ringCoords = nil
    DoScreenFadeOut(500)
    Wait(500)
    SetEntityCoordsNoOffset(cache.ped, coords.x, coords.y, coords.z, 0, 0, 0, false)
    Wait(500)
    DoScreenFadeIn(500)
end)

function playRingAudio(name)
    lib.requestAudioBank('audiodirectory/prompt_gym')
    local soundId = GetSoundId()
    if ringCoords then
        PlaySoundFromCoord(soundId, name, ringCoords.x, ringCoords.y, ringCoords.z, 'prompt_gym', false, 15.0, 0)
    else
        PlaySoundFromEntity(soundId, name, cache.ped, 'prompt_gym', false, 0)
    end
    CreateThread(function()
        while not HasSoundFinished(soundId) do
            Wait(0)
        end
        ReleaseSoundId(soundId)
    end)
end
RegisterNetEvent('gym:updateFightUI', function(data)
    SendNUIMessage({
        action = 'setRingFightData',
        data = data
    })
    if data and data.state == 'fighting' then
        playRingAudio('start')
    end
    if data and (data.state == 'winner' or data.state == 'draw' or data.state == 'loser') then
        if data.state == 'winner' then
            playRingAudio('victory')
        else
            playRingAudio('defeat')
        end
        if clientConfig.boxingRing.onFightEnd then
            pcall(clientConfig.boxingRing.onFightEnd, data.state)
        end
        SetTimeout(5000, function()
            SendNUIMessage({
                action = 'setRingFightData',
                data = nil
            })
        end)
    end
end)

AddStateBagChangeHandler('isBoxingRingBorder', nil, function(bagName, key, value)
    local entityId = GetEntityFromStateBagName(bagName)
    if not entityId then return end

    SetEntityVisible(entityId, false, 0)
end)