local playerPed = PlayerPedId()
local offset = GetOffsetFromEntityInWorldCoords(playerPed, 0.0, 0.0, -1.0)
local heading = GetEntityHeading(playerPed)

local testBind = AddKeyBind({
    name = "interact",
    description = "Interact",
    defaultKey = "E"
})

local controllerKeyBind = AddKeyBind({
    name = "interact_controller",
    description = "Interact (Controller)",
    defaultKey = "LRIGHT_INDEX",
    defaultMapper = "PAD_ANALOGBUTTON"
})

local interactPoint = AddInteractPoint({
    coords = vector4(offset.x, offset.y, offset.z, heading),
    helpText = "Interact",
    key = testBind,
    controllerKeyBind = controllerKeyBind,
    autoPerform = true,
    name = "TestInteract",
    options = {
        {
            label = "Success",
            icon = "fa-regular fa-circle-check",
            action = function(entity)
                infoprint("success", ":)")
                Notify("Success", "success")
            end
        },
        {
            label = "Error",
            icon = "fa-regular fa-circle-xmark",
            action = function(entity)
                infoprint("error", ":(")
                Notify("Error", "error")
            end
        },
        {
            label = "Input",
            icon = "fa-regular fa-keyboard",
            action = function(entity)
                local name = OpenInput("Test", "Name", "Enter your name", "fa-solid fa-user")

                debugprint(name)
            end
        }
    }
})

-- OpenMenu("test", {
--     {
--         label = "Abc",
--         options = { "a", "b", "c" },
--         action = function(menu, selectedItem)
--             debugprint("Selected item:", selectedItem)
--             CloseMenu()
--         end
--     }
-- })
