---@param resource string
local function IsResourceStartedOrStarting(resource)
	local state = GetResourceState(resource)

	return state == "started" or state == "starting"
end

if Config.Framework == "qb-core" or Config.Framework == "qb-core" then
	Config.Framework = "qbcore"
elseif Config.Framework == "es_extended" then
	Config.Framework = "esx"
elseif Config.Framework == "qbox" or Config.Framework == "qbx_core" then
	Config.Framework = "qbox"
end

if Config.Framework == "auto" then
	debugprint("Framework set to auto, detecting...")

	if IsResourceStartedOrStarting("es_extended") then
		Config.Framework = "esx"
	elseif IsResourceStartedOrStarting("qbx_core") then
		Config.Framework = "qbox"
	elseif IsResourceStartedOrStarting("qb-core") then
		Config.Framework = "qbcore"
	else
		Config.Framework = "custom"
	end

	debugprint("Detected framework: " .. Config.Framework)
end

if Config.Inventory == "auto" then
	debugprint("Inventory set to auto, detecting...")

	local inventoryScripts = {
		"ox_inventory",
		"qb-inventory",
		"lj-inventory",
		"core_inventory",
		"mf-inventory",
		"qs-inventory",
		"codem-inventory",
		"ps-inventory",
	}

	for i = 1, #inventoryScripts do
		local scriptName = inventoryScripts[i]

		if IsResourceStartedOrStarting(scriptName) then
			Config.Inventory = scriptName
			debugprint("Detected inventory script:", scriptName)
			break
		end
	end
end

if Config.NotificationSystem == "auto" then
	if IsResourceStartedOrStarting("ox_lib") then
		Config.NotificationSystem = "ox_lib"
	else
		Config.NotificationSystem = "framework"
	end
end

if Config.MenuSystem == "auto" then
	if IsResourceStartedOrStarting("ox_lib") then
		Config.MenuSystem = "ox_lib_context"
	elseif IsResourceStartedOrStarting("esx_context") then
		Config.MenuSystem = "esx_context"
	elseif IsResourceStartedOrStarting("esx_menu_default") then
		Config.MenuSystem = "esx_menu_default"
	elseif IsResourceStartedOrStarting("qb-menu") then
		Config.MenuSystem = "qb-menu"
	else
		infoprint("error", "[loaf_wrapper] No menu system detected.")
	end
end

if Config.Target == "auto" then
	if IsResourceStartedOrStarting("qtarget") then
		Config.Target = true
	else
		Config.Target = false
	end
end

if Config.HelpTextStyle == "auto" then
	local helpTextScripts = {
		"ox_lib",
		"okokTextUI",
		"jg-textui",
		"cd_drawtextui",
	}

	Config.HelpTextStyle = "gta"

	for i = 1, #helpTextScripts do
		local scriptName = helpTextScripts[i]

		if IsResourceStartedOrStarting(scriptName) then
			Config.HelpTextStyle = scriptName
			debugprint("Detected help text style:", scriptName)
			break
		end
	end
end

if Config.DispatchSystem == "auto" then
	if IsResourceStartedOrStarting("lb-tablet") then
		Config.DispatchSystem = "lb-tablet"
	end
end

if Config.CompanyMoneySystem == "auto" then
	local companyMoneyScripts = {
		"esx_addonaccount",
		"qb-banking",
		"Renewed-Banking",
		"renewed-banking",
		"qb-management",
	}

	for i = 1, #companyMoneyScripts do
		local scriptName = companyMoneyScripts[i]

		if IsResourceStartedOrStarting(scriptName) then
			Config.CompanyMoneySystem = scriptName
			debugprint("Detected company money system:", scriptName)
			break
		end
	end

	if Config.CompanyMoneySystem == "auto" then
		Config.CompanyMoneySystem = "template"
		infoprint("error", "[loaf_wrapper] No company money system detected, using template.")
	end
end

local shouldLoadOxLib = false

if
	not lib
	and (
		Config.NotificationSystem == "ox_lib"
		or Config.HelpTextStyle == "ox_lib"
		or (type(Config.MenuSystem) == "string" and Config.MenuSystem:find("ox_lib"))
	)
then
	shouldLoadOxLib = true
end

if shouldLoadOxLib then
	debugprint("Loading ox_lib...")

	local oxInit = LoadResourceFile("ox_lib", "init.lua")

	if oxInit then
		load(oxInit)()
		debugprint("Loaded ox_lib")
	else
		infoprint("error", "Failed to load ox_lib")
	end
end
