if Config.Framework ~= "qbox" then
    return
end

---@param source number
---@param account? LoafWrapperMoneyAccount
---@return number
function GetMoney(source, account)
    local qPlayer = GetQBPlayer(source)

    if not qPlayer then
        return 0
    end

    if not account then
        local cash = qPlayer.Functions.GetMoney("cash") or 0
        local bank = qPlayer.Functions.GetMoney("bank") or 0

        return math.max(cash, bank)
    end

    if account == "money" then
        return qPlayer.Functions.GetMoney("cash") or 0
    elseif account == "bank" then
        return qPlayer.Functions.GetMoney("bank") or 0
    end

    debugprint("GetMoney: Invalid account type (Qbox):", account)

    return 0
end

---@param source number
---@param amount number
---@param account? LoafWrapperMoneyAccount
---@return boolean success
function RemoveMoney(source, amount, account)
local qPlayer = GetQBPlayer(source)

    if not qPlayer then
        return false
    end

    if account then
        local money = GetMoney(source, account)

        if money >= amount then
            qPlayer.Functions.RemoveMoney(account == "money" and "cash" or "bank", amount)

            return true
        end

        return false
    end

    local cash = qPlayer.Functions.GetMoney("cash") or 0
    local bank = qPlayer.Functions.GetMoney("bank") or 0

    if cash >= amount then
        qPlayer.Functions.RemoveMoney("cash", amount)

        return true
    elseif bank >= amount then
        qPlayer.Functions.RemoveMoney("bank", amount)

        return true
    end

    return false
end

---@param source number
---@param amount number
---@param account? LoafWrapperMoneyAccount
---@return boolean
function AddMoney(source, amount, account)
    local qPlayer = GetQBPlayer(source)

    if not qPlayer then
        return false
    end

    if account == "black_money" then
        debugprint("AddMoney: Black money is not supported in QBox.")
        return false
    end

    account = account or "money"

    qPlayer.Functions.AddMoney(account == "money" and "cash" or "bank", amount)

    return true
end
