if Config.Framework ~= "qbcore" then
    return
end

debugprint("Loading QBCore")

QB = exports["qb-core"]:GetCoreObject()

---@param source number
function GetQBPlayer(source)
    return QB.Functions.GetPlayer(tonumber(source))
end

---@param source number
---@return string?
function GetIdentifier(source)
    local qPlayer = GetQBPlayer(source)

    if not qPlayer?.PlayerData?.citizenid then
        debugprint("GetIdentifier: Failed to get player for source:", source)
        return
    end

    return qPlayer.PlayerData.citizenid
end

---@param identifier string
---@return number?
function GetSourceFromIdentifier(identifier)
    local qPlayer = QB.Functions.GetPlayerByCitizenId(identifier)

    if qPlayer?.PlayerData?.source then
        return qPlayer.PlayerData.source
    end
end
