if not Config.CompanyMoneySystem or Config.CompanyMoneySystem:lower() ~= "renewed-banking" then
    return
end

---@param company string
---@param amount number
function RemoveCompanyMoney(company, amount)
    assert(type(company) == "string", "Company name must be a string")
    assert(type(amount) == "number" and amount > 0, "Amount must be a positive number")

    local balance = GetCompanyMoney(company)

    if balance < amount then
        debugprint("RemoveCompanyMoney: Insufficient funds in company:", company, "tried to remove:", amount, "balance:", balance)
        return false
    end

    return exports["Renewed-Banking"]:removeAccountMoney(company, amount)
end

---@param company string
---@param amount number
function AddCompanyMoney(company, amount)
    assert(type(company) == "string", "Company name must be a string")
    assert(type(amount) == "number" and amount > 0, "Amount must be a positive number")

    return exports["Renewed-Banking"]:addAccountMoney(company, amount)
end

---@param company string
function GetCompanyMoney(company)
    assert(type(company) == "string", "Company name must be a string")

    return exports["Renewed-Banking"]:getAccountMoney(company) or 0
end
