if Config.CompanyMoneySystem ~= "esx_addonaccount" then
    return
end

local function GetSocietyAccount(company)
    local p = promise.new()

    TriggerEvent("esx_addonaccount:getSharedAccount", "society_" .. company, function(account)
        p:resolve(account)
    end)

    return Citizen.Await(p)
end

---@param company string
---@param amount number
function RemoveCompanyMoney(company, amount)
    assert(type(company) == "string", "Company name must be a string")
    assert(type(amount) == "number" and amount > 0, "Amount must be a positive number")

    local account = GetSocietyAccount(company)

    if account.money < amount then
        debugprint("RemoveCompanyMoney: Insufficient funds in company:", company, "tried to remove:", amount, "balance:", account.money)
        return false
    end

    account.removeMoney(amount)

    return true
end

---@param company string
---@param amount number
function AddCompanyMoney(company, amount)
    assert(type(company) == "string", "Company name must be a string")
    assert(type(amount) == "number" and amount > 0, "Amount must be a positive number")

    local account = GetSocietyAccount(company)

    if not account then
        debugprint("AddCompanyMoney: No account found for company:", company)
        return false
    end

    account.addMoney(amount)

    return true
end

---@param company string
function GetCompanyMoney(company)
    assert(type(company) == "string", "Company name must be a string")

    local account = GetSocietyAccount(company)

    if not account then
        debugprint("GetCompanyMoney: No account found for company:", company)
        return 0
    end

    return account.money or 0
end
