---@class LoafWrapperDispatchOptions
---@field title string
---@field job? "police" | "ambulance" | string | string[]
---@field description? string
---@field location { label: string, coords: vector } | vector
---@field duration? number # in seconds
---@field disableSound? boolean
---@field blip? { label?: string, sprite?: number, color?: number, scale?: number }
---@field priority? 'high' | 'medium' | 'low'
---@field code? string

---@param options LoafWrapperDispatchOptions
local function AddLBTabletDispatch(options)
    local formattedOptions = {
        title = options.title,
        description = options.description or "",
        job = (options.job == "police" or options.job == "ambulance") and options.job or "police",
        duration = options.duration or 120,
        priority = options.priority or "medium",
        code = options.code or "",
        blip = options.blip and {
            label = options.blip.label or options.title,
            sprite = options.blip.sprite,
            color = options.blip.color,
            size = options.blip.scale
        },
    }

    if options.disableSound then
        formattedOptions.sound = false
    end

    if type(options.location) == "table" then
        ---@diagnostic disable-next-line: missing-fields
        formattedOptions.location = {
            label = options.location.label,
            coords = options.location.coords.xy
        }
    else
        formattedOptions.location = options.location.xy
    end

    exports["lb-tablet"]:AddDispatch(formattedOptions)
end

---@param options LoafWrapperDispatchOptions
function AddDispatch(options)
    if Config.DispatchSystem == "lb-tablet" then
        AddLBTabletDispatch(options)
    else
    end
end
