local sharedFiles = {
    "shared/default-config.lua",
    "shared/functions/functions.lua",
    "shared/functions/auto-detect.lua",
    "shared/functions/locales.lua",
    "shared/functions/interval.lua"
}

local serverFiles = {
    "server/callbacks/register-callbacks.lua",
    "server/callbacks/trigger-callbacks.lua",
    "server/dispatch.lua",
    "server/frameworks/company-money/template.lua",
    "server/frameworks/company-money/esx_addonaccount.lua",
    "server/frameworks/company-money/qb-banking.lua",
    "server/frameworks/company-money/qb-management.lua",
    "server/frameworks/company-money/renewed-banking.lua",
    "server/frameworks/esx/esx.lua",
    "server/frameworks/esx/job.lua",
    "server/frameworks/esx/money.lua",
    "server/frameworks/qb/money.lua",
    "server/frameworks/qb/qb.lua",
    "server/frameworks/qbox/money.lua",
    "server/frameworks/qbox/qbox.lua",
    "server/inventories/esx.lua",
    "server/inventories/ox_inventory.lua",
    "server/inventories/qb-inventory.lua"
}

local clientFiles = {
    "client/callbacks/nui.lua",
    "client/callbacks/register-callbacks.lua",
    "client/callbacks/trigger-callbacks.lua",
    "client/frameworks/esx/esx.lua",
    "client/frameworks/esx/job.lua",
    "client/frameworks/esx/menu.lua",
    "client/frameworks/qb/job.lua",
    "client/frameworks/qb/menu.lua",
    "client/frameworks/qb/qb.lua",
    "client/frameworks/qbox/job.lua",
    "client/frameworks/qbox/qbox.lua",
    "client/functions/buttons.lua",
    "client/functions/entity-interact.lua",
    "client/functions/functions.lua",
    "client/functions/interact.lua",
    "client/functions/keybinds.lua",
    "client/functions/marker.lua",
    "client/functions/menu.lua",
    "client/functions/point.lua",
    "client/functions/world-text.lua"
}

local wrapperState = GetResourceState("loaf_wrapper")
local hasWrapper = wrapperState == "started" or wrapperState == "starting"
local loadFromResource = hasWrapper and "loaf_wrapper" or GetCurrentResourceName()
local fileNamePrefix = hasWrapper and "" or "loaf_wrapper/"

local function LoadFiles(files)
    for i = 1, #files do
        local fileName = fileNamePrefix .. files[i]

        Citizen.CreateThreadNow(function()
            local fileContent = LoadResourceFile(loadFromResource, fileName)

            if not fileContent then
                return
            end

            local loadFunction, errorMessage = load(fileContent, "@@loaf_wrapper/" .. fileName)

            if loadFunction then
                pcall(loadFunction)
            else
                print("^1[ERROR]^7: Failed to load file '" .. fileName .. "': " .. errorMessage)
            end
        end)
    end
end

LoadFiles(sharedFiles)

if IsDuplicityVersion() then
    LoadFiles(serverFiles)
else
    LoadFiles(clientFiles)
end
