if Config.Framework ~= "qbcore" then
    return
end

debugprint("Loading QBCore")

QB = exports["qb-core"]:GetCoreObject()

PlayerJob = {}
PlayerData = {}

while not LocalPlayer.state.isLoggedIn do
    Wait(500)
end

PlayerJob = QB.Functions.GetPlayerData().job
PlayerData = QB.Functions.GetPlayerData()

RegisterNetEvent("QBCore:Client:OnPlayerLoaded", function()
    PlayerData = QB.Functions.GetPlayerData()
    PlayerJob = PlayerData.job

    TriggerEvent(GetCurrentResourceName() .. ":jobUpdated", {
        name = PlayerJob.name,
        grade = PlayerJob.grade.level,
        label = PlayerJob.label,
        gradeLabel = PlayerJob.grade.name,
    })
end)

RegisterNetEvent("QBCore:Client:OnPlayerUnload", function()
    PlayerData = {}
end)

RegisterNetEvent("QBCore:Player:SetPlayerData", function(newData)
    PlayerData = newData
end)

FrameworkLoaded = true

debugprint("Loaded QBCore")
