local resourceName = GetCurrentResourceName()

---@param event string
---@param handler fun(...) : ...
function RegisterClientCallback(event, handler)
    assert(type(event) == "string", "event must be a string")

    RegisterNetEvent(resourceName .. ":cb:" .. event, function(requestId, ...)
        local params = { ... }
        local startTime = GetGameTimer()

        local success, errorMessage = pcall(function()
            TriggerServerEvent(resourceName .. ":cb:response", requestId, handler(table.unpack(params)))

            local ms = GetGameTimer() - startTime

            debugprint(("Callback ^5%s^7 took %ims"):format(event, ms))
        end)

        if not success then
            local stackTrace = Citizen.InvokeNative(`FORMAT_STACK_TRACE` & 0xFFFFFFFF, nil, 0, Citizen.ResultAsString())

            print(("^1SCRIPT ERROR: Client callback '%s' failed: %s^7\n%s"):format(event, errorMessage or "", stackTrace or ""))
        end
    end)
end
