---@param event string
---@param callback fun(data: any) : ...
---@param defaultReturn any
function RegisterSyncNUICallback(event, callback, defaultReturn)
    if defaultReturn == nil then
        defaultReturn = false
    end

    RegisterNUICallback(event, function(data, nuiCallback)
        local eventTitle = event
        local action

        if type(data) == "table" and data.action then
            action = data.action
            eventTitle = event .. ":" .. action
        end

        local startTime = GetGameTimer()
        local success, result = pcall(callback, data)
        local finishTime = GetGameTimer()
        local ms = finishTime - startTime

        if result == nil then
            result = defaultReturn
        end

        if success then
            nuiCallback(result)
            debugprint(("NUI callback ^5%s^7 took %ims"):format(eventTitle, ms))
        else
            local stackTrace = Citizen.InvokeNative(`FORMAT_STACK_TRACE` & 0xFFFFFFFF, nil, 0, Citizen.ResultAsString())

            print(
                ("^1SCRIPT ERROR: NUI Callback '%s' failed: %s^7\n%s"):format(
                    eventTitle,
                    result or "",
                    stackTrace or ""
                )
            )

            nuiCallback(defaultReturn)
        end
    end)
end

---@param action string
---@param data any
function SendNUIAction(action, data)
    SendNUIMessage({
        action = action,
        data = data,
    })
end
