# loaf_wrapper

A FiveM wrapper for different frameworks & libs.

## Usage as dependency

Add the following to your `fxmanifest.lua`:

```lua
shared_script "@loaf_wrapper/load.lua"

dependency "loaf_wrapper"
```

Make sure to add the `shared_script` before any other files, but after your config.

## Usage as submodule

### .gitignore

Put the following in your `.gitignore`:

```.gitignore
/loaf_wrapper/README.md
/loaf_wrapper/.gitignore
/loaf_wrapper/.gitattributes
/loaf_wrapper/fxmanifest.lua
/loaf_wrapper/server/generate.js
/loaf_wrapper/tests/
/loaf_wrapper/.vscode/

```

### Add to fxmanifest

Add the following to your `fxmanifest.lua`:

```lua
shared_script "loaf_wrapper/load-internal.lua"

files {
    "loaf_wrapper/client/**",
    "loaf_wrapper/shared/**"
}
```

Make sure to add the `shared_script` before any other files, but after your config.

### Adding submodule

1. Make sure to commit & push all changes, if any
2. `git remote add loaf_wrapper https://github.com/loaf-scripts/loaf_wrapper`
3. `git subtree add --prefix=loaf_wrapper loaf_wrapper main --squash`
4. `git push`

### Pulling the submodule

1. Make sure to commit & push all changes, if any. Alternatively, stash all changes by doing `git stash`
2. `GIT_EDITOR=true git subtree pull --prefix=loaf_wrapper loaf_wrapper main --squash`
3. `git stash pop`
4. `git push`
