function AddInventoryItem(src, item, count)
	if Config.inventory == "esx" then
		local xPlayer = ESX.GetPlayerFromId(src)
		xPlayer.addInventoryItem(item, count)
	elseif Config.inventory == "qb" then
		local player = QBCore.Functions.GetPlayer(source)
		player.Functions.AddItem(item, count)
	elseif Config.inventory == "core" then
		exports.core_inventory:addItem(src, item, count)
	elseif Config.inventory == "qs" then
		exports["qs-inventory"]:AddItem(src, item, count)
	elseif Config.inventory == "tgiann" then
		exports["tgiann-inventory"]:AddItem(src, item, count)
	elseif Config.inventory == "ox_inventory" then
		exports.ox_inventory:AddItem(src, item, count)
	elseif Config.inventory == "qb-inventory" then
		exports["qb-inventory"]:AddItem(src, item, count)
	elseif Config.inventory == "ps-inventory" then
		return exports["ps-inventory"]:AddItem(src, item, count)
	elseif Config.inventory == "codem" then
		exports["codem-inventory"]:AddItem(src, item, count)
	end
end

function RemoveInventoryItem(src, item, count)
	if Config.inventory == "esx" then
		local xPlayer = ESX.GetPlayerFromId(src)

		xPlayer.removeInventoryItem(item, count)
	elseif Config.inventory == "qb" then
		local player = QBCore.Functions.GetPlayer(source)

		player.Functions.RemoveItem(item, count)
	elseif Config.inventory == "core" then
		exports.core_inventory:removeItem(src, item, count)
	elseif Config.inventory == "qs" then
		exports["qs-inventory"]:RemoveItem(src, item, count)
	elseif Config.inventory == "tgiann" then
		exports["tgiann-inventory"]:RemoveItem(src, item, count)
	elseif Config.inventory == "ox_inventory" then
		exports.ox_inventory:RemoveItem(src, item, count)
	elseif Config.inventory == "qb-inventory" then
		exports["qb-inventory"]:RemoveItem(src, item, count)
	elseif Config.inventory == "ps-inventory" then
		return exports["ps-inventory"]:RemoveItem(src, item, count)
	elseif Config.inventory == "codem" then
		exports["codem-inventory"]:RemoveItem(src, item, count)
	end
end

function GetInventoryCount(src, item)
	if Config.inventory == "esx" then
		local xPlayer = ESX.GetPlayerFromId(src)

		return xPlayer.getInventoryItem(item).count
	elseif Config.inventory == "qb" then
		local player = QBCore.Functions.GetPlayer(source)

		return player.Functions.GetItemByName(item).amount
	elseif Config.inventory == "core" then
		return exports.core_inventory:getItemCount(src, item)
	elseif Config.inventory == "qs" then
		return exports["qs-inventory"]:GetItemTotalAmount(src, item)
	elseif Config.inventory == "tgiann" then
		return exports["tgiann-inventory"]:GetItemCount(src, item)
	elseif Config.inventory == "ox_inventory" then
		return exports.ox_inventory:GetItemCount(src, item)
	elseif Config.inventory == "qb-inventory" then
		return exports["qb-inventory"]:GetItemCount(src, item)
	elseif Config.inventory == "ps-inventory" then
		return exports["ps-inventory"]:GetItemCount(src, item)
	elseif Config.inventory == "codem" then
		return exports["codem-inventory"]:GetItemsTotalAmount(src, item)
	end
end

RegisterNetEvent("electus_gangs:openStash", function(crateId, zoneId)
	local src = source
	local player = GetPlayer(src)

	local stashId = zoneId .. ":" .. crateId

	if Config.inventory == "ox_inventory" then
		exports.ox_inventory:RegisterStash(
			stashId,
			L("warehouse.crate"),
			Config.warehouse.slots,
			Config.warehouse.weight
		)
	elseif Config.inventory == "qb-inventory" then
		exports["qb-inventory"]:OpenInventory(
			src,
			stashId,
			{ label = L("warehouse.crate"), maxweight = Config.warehouse.weight, slots = Config.warehouse.slots }
		)
	elseif Config.inventory == "ps-inventory" then
		exports["ps-inventory"]:OpenInventory(
			src,
			stashId,
			{ label = L("warehouse.crate"), maxweight = Config.warehouse.weight, slots = Config.warehouse.slots }
		)
	elseif Config.inventory == "core" then
		stashId = zoneId .. "-" .. crateId
		exports.core_inventory:openInventory(nil, stashId, "stash", nil, nil, false, nil, false)

		exports.core_inventory:openInventory(src, stashId, L("warehouse.crate"), "stash", nil, nil, true, nil, false)
	end
end)
