RegisterNetEvent("electus_gangs:cuffPlayer", function(playerId)
	local src = source

	TriggerClientEvent("electus_gangs:getCuffed", playerId, src)
end)

RegisterNetEvent("electus_gangs:uncuffPlayer", function(playerId)
	TriggerClientEvent("electus_gangs:getUncuffed", playerId)
end)

RegisterNetEvent("electus_gangs:escortPlayer", function(playerId)
	local src = source
	TriggerClientEvent("electus_gangs:getEscorted", playerId, src)
end)

RegisterNetEvent("electus_gangs:taskLeaveVehicle", function(vehNet, seatIndex)
	local src = source
	local veh = NetworkGetEntityFromNetworkId(vehNet)
	local ped = GetPedInVehicleSeat(veh, seatIndex)

	if Entity(ped).state.escortedIntoVehicle then
		TaskLeaveVehicle(ped, veh, 0)
		Entity(ped).state:set("escortedIntoVehicle", false, true)
	end
end)

RegisterNetEvent("electus_gangs:warpPlayerIntoVehicle", function(vehNet, playerId, seat)
	local src = source
	local ped = GetPlayerPed(src)
	local pedCoords = GetEntityCoords(ped)
	local targetPed = GetPlayerPed(playerId)
	local targetCoords = GetEntityCoords(targetPed)
	local veh = NetworkGetEntityFromNetworkId(vehNet)

	if #(pedCoords - targetCoords) < 5.0 then
		Entity(targetPed).state:set("escortedIntoVehicle", true, true)
		Entity(targetPed).state:set("escorted", false, true)
		TaskWarpPedIntoVehicle(targetPed, veh, seat)
	end
end)

lib.callback.register("electus_gangs:createHeadBag", function(src)
	local ped = GetPlayerPed(src)
	local coords = GetEntityCoords(ped)
	local headBag = CreateObject(GetHashKey("prop_money_bag_01"), coords.x, coords.y, coords.z, true, true, true)

	while not DoesEntityExist(headBag) do
		Wait(0)
	end

	return NetworkGetNetworkIdFromEntity(headBag)
end)

RegisterNetEvent("electus_gangs:removeHeadbagObject", function(objNet)
	local obj = NetworkGetEntityFromNetworkId(objNet)

	if DoesEntityExist(obj) then
		DeleteEntity(obj)
	end
end)
