Config = {
	framework = "auto", -- "auto", "esx", "qb", "qbx"
	inventory = "ox_inventory", -- "ox_inventory", "core", "qs", "tgiann", "esx", "qb", "codem", "qb-inventory" (if it doesnt work test "esx" or "qb")
	targetSystem = "ox_target", -- "qtarget", "ox_target", "qb-target" and more
	locale = "en",
	xpNeededForNextLevel = 100,
	debug = false,
	keyActions = { -- if you change KeyActions the Key must also be avaliable in Keys table.
		placeMarker = "E",
		cancel = "BACKSPACE",
		pressToExitIpl = "E",
		openLaunderingMenu = "E",
		startCapturingZone = "E",
		startDefendingZone = "E",
		storeVehicle = "E",
		openGarageMenu = "E",
		openSafeHouseMenu = "E",
		enterIpl = "E",
		plantWeed = "E",
		confirmVehicleSpawnPosition = "E",
		rotateVehicle = "R",
		openGarage = "E",
		stopEscorting = "G",
		openGangShopMenu = "E",
		createDoor = "E",
		openDoor = "E",
		closeDoor = "E",
		placeObject = "E",
		rotateObject = "G",
	},
	gangShop = {
		enabled = false,
		coords = { x = 357.22, y = -1809.56, z = 28.6 },
		price = 100000,
	},
	connectedZones = { -- this is used to connect zones together and for gangs to capture one zone at a time
		enable = true, -- enable connected zones
		minNumberOfConnectionBetweenZones = 3, -- recommended 2-3
		maxAngleBetweenConnectedZones = 20, -- if the previous connection and current is less than this value another connection will be created (useful if you want to spread out your connections)
		onlyShowConnectedZones = true, -- only show connected zones
	},
	tabletItem = false, -- false or "gang_tablet" or other item
	attacks = {
		preperationTime = 24, -- time before the raid/capture is going live (in hours)
		durationTime = 60, -- in minutes how long the raid/capture will last
		minimumGangMembersOnline = -1, -- -1 to disable, minimum number of gang members online (defenders) to start an attack
		raid = {
			enable = true, -- enable raids
			doors = {
				requiredItem = false, -- false to disable required item to open the safe, or set to item e.g. "lockpick"
				breakIntoAction = function()
					return lib.skillCheck({ "easy", "medium" }, { "w", "a", "s", "d" }) -- https://overextended.dev/ox_lib/Modules/Interface/Client/skillcheck
				end,
			},
			safe = {
				enable = true, -- enable safe in raids
				cashPercentage = { -- random percentage of the safe that can be taken when raided
					min = 0.2, -- minimum percentage of the safe that can be taken
					max = 0.4, -- maximum percentage of the safe that can be taken
				},
				dirtyCashPercentage = {
					min = 0.3,
					max = 0.6,
				},
				requiredItem = false, -- false to disable required item to open the safe, or set to item e.g. "lockpick"
				breakIntoAction = function()
					return lib.skillCheck({ "easy", "medium", "hard" }, { "w", "a", "s", "d" }) -- https://overextended.dev/ox_lib/Modules/Interface/Client/skillcheck
				end,
			},
		},
	},
	capturing = {
		captureProgressTypes = {
			{
				name = "drugCapture", -- this is the name used when calling the export
				label = "Drug Capture",
				description = "Capture the zone by selling drugs in it.",
			},
			{
				name = "graffiti", -- this is the name used when calling the export
				label = "Graffiti",
				description = "Capture the zone by spraying graffiti in it.",
			},
			-- add more here if you plan to use the exports
		},
	},
	showLogoOnMap = true, -- show gang logo on map
	safe = {
		onlyGangCanOpenSafe = true, -- if true, only gang members can open the safe when its opened otherwise anyone can open it
	},
	gangMenu = { -- ways to open gang menu
		marker = true,
		command = true,
		lbTablet = true,
	},
	garage = {
		garageSystem = "jg-advancedgarages", -- "esx_garage", "jg-advancedgarages", "qb_garages", "cd_garage"
		enableGangGarage = true,
		enablePersonalGarage = true,
	},
	moneyLaundering = {
		amountPerHour = 500,
		useGangDirtyCash = false, -- use gang dirty cash instead of player dirty cash
	},
	numberOfNPCDefendersWaves = 3,
	restrictWeedPlantingToZoneGang = false,
	selectPlayerDist = -1, -- will only include players within this distance (or -1 to select all)
	enableGangActions = true,
	npcDefenderWeapons = "WEAPON_PISTOL",
	actionItems = {
		ziptie = "ziptie", -- item to ziptie someone
		headbag = "headbag", -- item to put a headbag on someone
		remove_zipetie = "WEAPON_KNIFE", -- item to remove ziptie
	},
	zones = {
		respect = { -- respect is gained every day as long as the gang controlls the zone
			min = 0,
			max = 100,
			gain = 2,
		},
		npcDefenders = {
			randomModels = {
				`g_m_y_famca_01`,
				`g_m_y_famdnf_01`,
				`g_m_y_famfor_01`,
			},
		},
	},
	dateLanguage = "en-US",
	dirtyCashItem = "black_money", -- set to false if you do not have dirty cash as an item
	adminGroupName = "admin",

	safeHouseIpls = {
		{
			id = "bikersClubHouse1",
			name = "Bikers Club House 1",
		},
		{
			id = "bikersClubHouse2",
			name = "Bikers Club House 2",
		},
	},
	ipls = {
		["moneyLaundering"] = {
			spawnCoords = { x = 1138.0, y = -3198.8, z = -40.5 },
			menuCoords = { x = 1126.05, y = -3196.83, z = -40.6 },
		},
		["bikersClubHouse1"] = {
			spawnCoords = { x = 1121.09, y = -3152.0, z = -38.0 },
		},
		["bikersClubHouse2"] = {
			spawnCoords = { x = 998.4809, y = -3164.711, z = -38.90733 },
		},
		["warehouse"] = {
			spawnCoords = { x = 1087.94, y = -3099.34, z = -39.95 },
		},
		["weedProcessing"] = {
			spawnCoords = { x = 1088.63, y = -3187.64, z = -39.95 },
		},
	},
	policeJobs = {
		"police",
	},
	gangReputation = {
		["captureZone"] = 50,
		["loseZone"] = -50,
		["recruitMember"] = 100,
		["kick"] = -100,
		["sellDrugs"] = 2,
		["lootBoatCrate"] = 5,
		["lootContainer"] = 3,
	},
	weed = {
		canPlantEverywhere = false, -- if true, you can plant weed anywhere, if false, you can only plant weed in the zone where your gang is located
		maxDistance = 2.0, -- max distance between plants
		growthInterval = 1.0, -- in hours
		growth = 10, -- how much the plant will grow each growth interval (default 4% each hour = 100% in 25 hours)
		fertilizer = {
			decrease = 10, -- value that fertilizer will decrease by each hour
			use = {
				fertilizerIncrease = 25, -- how much health will increase when used
				healthIncrease = 10, -- how much health will increase when used
			},
			low = { -- if the plant is under 25% water
				value = 25, -- under 25%
				healthDecrease = 5, -- how much health will decrease each hour
			},
			medium = { -- if the plant is under 50% water
				value = 50, -- under 50%
				healthDecrease = 2, -- how much health will decrease each hour
			},
		},
		water = {
			decrease = 15, -- value that water will decrease by each hour
			use = {
				waterIncrease = 25, -- how much water will increase when used
				healthIncrease = 5, -- how much health will increase when used
			},
			low = { -- if the plant is under 25% water
				value = 25, -- under 25%
				healthDecrease = 5, -- how much health will decrease each hour
			},
			medium = { -- if the plant is under 50% water
				value = 50, -- under 50%
				healthDecrease = 2, -- how much health will decrease each hour
			},
		},
	},
}

if Config.targetSystem == "ox_target" then -- do not touch this
	Config.targetSystem = "qtarget"
end
