RegisterNUICallback("get_roles", function(data, cb)
	local roles = lib.callback.await("electus_gangs:getRoles", false, data.gangId)
	cb(roles)
end)

RegisterNUICallback("get_members", function(data, cb)
	local members = lib.callback.await("electus_gangs:getMembers", false, data.gangId, data.page)
	cb(members)
end)

RegisterNUICallback("get_captured_zones", function(data, cb)
	local zones = lib.callback.await("electus_gangs:getCapturedZones", false)
	cb(zones)
end)

RegisterNUICallback("get_gangs", function(data, cb)
	local gangs = lib.callback.await("electus_gangs:getGangs", false)
	cb(gangs)
end)

RegisterNUICallback("calling_cops", function(data, cb)
	local coords = GetEntityCoords(PlayerPedId())
	TriggerServerEvent("electus_gangs:callCops", coords)
	cb({})
end)

RegisterNUICallback("alerting_gang", function(data, cb)
	local myGang = GetPlayerGangId()
	local currentZone = GetPlayerZone()

	if not currentZone then
		return cb({})
	end

	local zoneGang = lib.callback.await("electus_gangs:getZoneGangOwner", false, currentZone.id)

	if not zoneGang or not zoneGang.gangId then
		return cb({})
	end

	if myGang == zoneGang?.gangId then
		return cb({})
	end

	TriggerServerEvent(
		"electus_gangs:alertGang",
		zoneGang.gangId,
		GetEntityCoords(PlayerPedId()),
		L("attempted_drug_sell")
	)

	CreateAlert(
		zoneGang.gangId,
		L("attempted_drug_sell"),
		L("someone_called_in_drug_sell"),
		GetEntityCoords(PlayerPedId())
	)

	TriggerServerEvent("electus_gangs:notifyGangMembers", zoneGang.gangId, L("someone_called_in_drug_sell"), "warning")

	cb({})
end)

RegisterNUICallback("get_money_laundering_load", function(data, cb)
	local moneyLaundery = lib.callback.await("electus_gang:getMoneyLaundering", false, EnteredZoneId)
	cb(moneyLaundery)
end)

RegisterNUICallback("create_new_role", function(data, cb)
	local await = lib.callback.await("electus_gangs:createRole", false, data.gangId, data.roleData)
	cb({})
end)

RegisterNUICallback("fire_member", function(data, cb)
	local resp = lib.callback.await("electus_gangs:fireMember", false, data.gangId, data.identifier)
	cb(resp)
end)

RegisterNUICallback("save_role", function(data, cb)
	local await = lib.callback.await("electus_gangs:updateRole", false, data.gangId, data.roleId, data.roleData)
	cb({})
end)

RegisterNUICallback("delete_role", function(data, cb)
	local await = lib.callback.await("electus_gangs:deleteRole", false, data.gangId, data.roleId)
	cb({})
end)

RegisterNUICallback("get_online_players", function(data, cb)
	local players = lib.callback.await("electus_gangs:getOnlinePlayers", false)
	cb(players)
end)

RegisterNUICallback("get_upgrades", function(data, cb)
	local upgrades = lib.callback.await("electus_gangs:getUpgrades", false, data.gangId)

	cb(upgrades)
end)

RegisterNUICallback("load_utils", function(data, cb)
	while not AwaitMainEscrow do
		Wait(1000)
	end
	cb({ locale = GetAllLocales(), config = Config, theme = Config.ui.theme })
end)

RegisterNUICallback("upgrade_item", function(data, cb)
	local await = lib.callback.await("electus_gangs:upgradeItem", false, data.gangId, data.item)
	UpdateGangMenuUI()
	cb(await)
end)

RegisterNUICallback("purchase_vehicle", function(data, cb)
	local await = lib.callback.await("electus_gangs:purchaseVehicle", false, data.gangId, data.model)
	UpdateGangMenuUI()
	cb(await)
end)

RegisterNUICallback("get_daily_data", function(data, cb)
	local await = lib.callback.await("electus_gangs:getDailyStatistics", false, data.gangId)
	cb(await)
end)

RegisterNUICallback("get_monthly_data", function(data, cb)
	local await = lib.callback.await("electus_gangs:getMonthlyStatistics", false, data.gangId)
	cb(await)
end)

RegisterNUICallback("get_weekly_data", function(data, cb)
	local await = lib.callback.await("electus_gangs:getWeeklyStatistics", false, data.gangId)
	cb(await)
end)

RegisterNUICallback("get_config", function(data, cb)
	cb(Config)
end)

RegisterNUICallback("create_gang", function(data, cb)
	TriggerServerEvent("electus_gangs:createGang", data.name, data.safeHouseZoneId, data.owner)
	ReloadAndCloseUI()
	cb({})
end)

RegisterNUICallback("get_my_grade", function(data, cb)
	local grade = lib.callback.await("electus_gangs:getMyGrade", false, data.gangId)
	cb(grade)
end)

RegisterNUICallback("get_zone_weed_amount", function(data, cb)
	local plants = lib.callback.await("electus_gangs:getZoneWeedAmount", false, data.zoneId)
	cb(plants)
end)

RegisterNUICallback("recruit_player", function(data, cb)
	TriggerServerEvent("electus_gangs:sendRecruitRequest", data.gangId, data.playerId)
	cb({})
end)

RegisterNUICallback("get_transactions_homepage", function(data, cb)
	local transactions = lib.callback.await("electus_gangs:getTransactionsHomepage", false, data.gangId)
	cb(transactions)
end)

RegisterNUICallback("get_transactions", function(data, cb)
	local transactions = lib.callback.await("electus_gangs:getTransactions", false, data.gangId, data.page)
	cb(transactions)
end)

RegisterNUICallback("get_safe_data", function(data, cb)
	local data = lib.callback.await("electus_gangs:getSafeData", false, data.gangId)
	cb(data)
end)

local antiSpam = false

RegisterNUICallback("deposit_dirty", function(data, cb)
	if antiSpam then
		return cb({})
	end

	antiSpam = true

	local await = lib.callback.await("electus_gangs:depositDirty", false, data.gangId, data.amount)
	if await then
		UpdateGangMenuUI()
	end
	antiSpam = false
	cb(await)
end)

RegisterNUICallback("withdraw_dirty", function(data, cb)
	if antiSpam then
		return cb({})
	end

	antiSpam = true

	local await = lib.callback.await("electus_gangs:withdrawDirty", false, data.gangId, data.amount)
	if await then
		UpdateGangMenuUI()
	end
	antiSpam = false
	cb(await)
end)

RegisterNUICallback("deposit", function(data, cb)
	if antiSpam then
		return cb({})
	end

	antiSpam = true
	local await = lib.callback.await("electus_gangs:deposit", false, data.gangId, data.amount)

	if await then
		UpdateGangMenuUI()
	end

	antiSpam = false
	cb(await)
end)

RegisterNUICallback("withdraw", function(data, cb)
	if antiSpam then
		return cb({})
	end

	antiSpam = true

	local await = lib.callback.await("electus_gangs:withdraw", false, data.gangId, data.amount)

	if await then
		UpdateGangMenuUI()
	end

	antiSpam = false
	cb(await)
end)

RegisterNUICallback("promote_role", function(data, cb)
	local await = lib.callback.await("electus_gangs:promoteRole", false, data.gangId, data.roleId)
	cb(await)
end)

RegisterNUICallback("demote_role", function(data, cb)
	local await = lib.callback.await("electus_gangs:demoteRole", false, data.gangId, data.roleId)
	cb(await)
end)

RegisterNUICallback("get_logs", function(data, cb)
	local logs = lib.callback.await("electus_gangs:getLogs", false, data.gangId, data.page)
	cb(logs)
end)

RegisterNUICallback("set_gang_owner", function(data, cb)
	local await = lib.callback.await("electus_gangs:setGangOwner", false, data.gangId, data.identifier)
	cb(await)
end)
RegisterNUICallback("set_gang_color", function(data, cb)
	local await = lib.callback.await("electus_gangs:setGangColor", false, data.gangId, data.color)
	cb(await)
end)

RegisterNUICallback("set_gang_name", function(data, cb)
	local await = lib.callback.await("electus_gangs:setGangName", false, data.gangId, data.name)
	cb(await)
end)

RegisterNUICallback("get_scoreboard", function(data, cb)
	local scoreboard = lib.callback.await("electus_gangs:getScoreboard", false)
	cb(scoreboard)
end)

RegisterNUICallback("get_identifier", function(data, cb)
	local name = lib.callback.await("electus_gangs:getIdentifier", false, data.id)
	cb(name)
end)

RegisterNUICallback("get_identifier_name", function(data, cb)
	local name = lib.callback.await("electus_gangs:getIdentifierName", false, data.identifier)
	cb(name)
end)

RegisterNUICallback("remove_gang", function(data, cb)
	ReloadAndCloseUI()
	local await = lib.callback.await("electus_gangs:removeGang", false, data.gangId)
	cb(await)
end)

RegisterNUICallback("update_gang", function(data, cb)
	ReloadAndCloseUI()
	local await = lib.callback.await("electus_gangs:updateGang", false, data.gang)
	cb(await)
end)

RegisterNUICallback("get_my_role_id", function(data, cb)
	local gang = lib.callback.await("electus_gangs:getMyRoleId", false)
	cb(gang)
end)

RegisterNUICallback("set_gps_marker", function(data, cb)
	SetNewWaypoint(data.pos.x, data.pos.y)
	cb({})
end)

RegisterNUICallback("change_role", function(data, cb)
	local hasChanged = lib.callback.await("electus_gangs:changeRole", false, data.gangId, data.identifier, data.roleId)
	cb(hasChanged)
end)

RegisterNUICallback("set_event_waypoint", function(data, cb)
	local event = data.event
	local coords = nil

	if event == "harbourContainers" then
		coords = Config.events.harbourContainers.containers[1].coords
	elseif event == "boatCrates" then
		coords = Config.events.boatCrates.ladders[1].coords
	end

	if coords then
		SetNewWaypoint(coords.x, coords.y)
	end
end)
