if (Config.framework ~= "qbx") and (Config.framework ~= "auto" or GetResourceState("qbx_core") ~= "started") then
    return
end

-- Haal Qbox core op
local QBX = exports['qbx_core']:GetCoreObject()
PlayerData = {}

CreateThread(function()
    Wait(1000)

    if LocalPlayer.state.isLoggedIn then
        TriggerEvent("electus_gangs:updateZones")
        TriggerEvent("electus_gangs:updateNextCaptureZones")

        TriggerEvent("electus_gangs:playerLoaded")
        OnPlayerLoad()
    end
end)

RegisterNetEvent("QBCore:Client:OnPlayerLoaded", function()
    PlayerData = QBX:GetPlayerData()
    TriggerEvent("electus_gangs:updateZones")
    TriggerEvent("electus_gangs:updateNextCaptureZones")

    TriggerEvent("electus_gangs:playerLoaded")
    OnPlayerLoad()
end)

RegisterNetEvent("QBCore:Client:OnJobUpdate", function()
    TriggerEvent("electus_gangs:zonesUpdated")
end)

function GetJobName()
    local PlayerData = QBX:GetPlayerData()
    return PlayerData.job and PlayerData.job.name or ""
end

function GetIdentifier()
    local PlayerData = QBX:GetPlayerData()
    return PlayerData.citizenid or ""
end

function ApplyVehicleMods(vehicleEnt, vehicle)
    if type(vehicle) == "string" then
        vehicle = json.decode(vehicle)
    end

    SetVehicleNumberPlateText(vehicleEnt, vehicle.plate)
    lib.setVehicleProperties(vehicleEnt, vehicle)

    TriggerEvent("vehiclekeys:client:SetOwner", exports.qbx_core:getVehiclePlate(vehicleEnt))

    if GetResourceState("LegacyFuel") == "started" and vehicle.fuel then
        exports.LegacyFuel:SetFuel(vehicleEnt, vehicle.fuel)
    end
end

function GetVehicleMods(vehicleEnt)
    return lib.getVehicleProperties(vehicleEnt)
end