if (Config.framework ~= "qb") and (Config.framework ~= "auto" or GetResourceState("qb-core") ~= "started") then
	return
end

PlayerData = {}
QBCore = exports["qb-core"]:GetCoreObject()

CreateThread(function()
	Wait(1000)

	if LocalPlayer.state.isLoggedIn then
		TriggerEvent("electus_gangs:updateZones")
		TriggerEvent("electus_gangs:updateNextCaptureZones")

		TriggerEvent("electus_gangs:playerLoaded")
		OnPlayerLoad()
	end
end)

RegisterNetEvent("QBCore:Client:OnPlayerLoaded", function()
	PlayerData = QBCore.Functions.GetPlayerData()

	TriggerEvent("electus_gangs:updateZones")
	TriggerEvent("electus_gangs:updateNextCaptureZones")

	TriggerEvent("electus_gangs:playerLoaded")
	OnPlayerLoad()
end)

RegisterNetEvent("QBCore:Client:OnPlayerUnload", function()
	PlayerData = {}
end)

RegisterNetEvent("QBCore:Client:OnJobUpdate", function()
	TriggerEvent("electus_gangs:zonesUpdated")
end)

function GetJobName()
	local job = QBCore.Functions.GetPlayerData().job.name or ""

	return job
end

function GetIdentifier()
	local identifier = QBCore.Functions.GetPlayerData().citizenid

	return identifier
end

function ApplyVehicleMods(vehicleEnt, vehicle)
	if type(vehicle) == "string" then
		vehicle = json.decode(vehicle)
	end

	SetVehicleNumberPlateText(vehicleEnt, vehicle.plate)

	QBCore.Functions.SetVehicleProperties(vehicleEnt, vehicle or {})
	TriggerEvent("vehiclekeys:client:SetOwner", QBCore.Functions.GetPlate(vehicleEnt))

	if GetResourceState("LegacyFuel") == "started" and vehicle.fuel then
		exports.LegacyFuel:SetFuel(vehicleEnt, vehicle.fuel)
	end
end

function GetVehicleMods(vehicleEnt)
	local mods = QBCore.Functions.GetVehicleProperties(vehicleEnt)
	return mods
end
