function ToggleNuiFrame(shouldShow)
	DisableIdleCamera(shouldShow)
	SetNuiFocus(shouldShow, shouldShow)

	SendReactMessage("setVisible", shouldShow)

	if not shouldShow then
		InGangMenu = false
		StopAnim()
	end
end

function ToggleVisibility(shouldShow)
	SendReactMessage("setVisible", shouldShow)
end

RegisterCommand("show-nui", function()
	ToggleNuiFrame(true)
end, false)

RegisterNUICallback("hideFrame", function(_, cb)
	if InsideNPCDialog then
		EndDrugSellScene()
	end
	ToggleNuiFrame(false)
	InsidePasswordChange = false
	InGangMenu = false
	cb({})
end)

RegisterCommand("close", function()
	ToggleNuiFrame(false)
end, false)

RegisterNetEvent("electus_gangs:manageGangs", function()
	SendReactMessage("updateComponent", {
		component = "gangCreator",
	})
	ToggleNuiFrame(true)
end)

function SpawnVehicle(vehicle, coords, gangVehicle)
	local netVeh = lib.callback.await("electus_gangs:spawnVehicle", false, vehicle, coords, gangVehicle)

	while not NetworkDoesNetworkIdExist(netVeh) do
		Wait(0)
	end

	local vehicleEnt = NetToVeh(netVeh)

	TaskWarpPedIntoVehicle(PlayerPedId(), vehicleEnt, -1)
	ApplyVehicleMods(vehicleEnt, vehicle)
end

function StoreVehicle(zone)
	local vehicle = GetVehiclePedIsIn(PlayerPedId(), false)
	if not DoesEntityExist(vehicle) then
		return
	end
	local vehProps = GetVehicleMods(vehicle)

	local removed = lib.callback.await("electus_gangs:storeVehicle", false, zone, vehProps)

	if removed?.jgSaveOnClient then
		TriggerEvent("jg-advancedgarages:client:store-vehicle", "gang:" .. GetPlayerGangId(), "car")
	elseif removed?.remove then
		DeleteEntity(vehicle)
	end
end

function OpenCrate(zoneId, crateId)
	if Config.inventory == "ox_inventory" then
		if not exports["ox_inventory"]:openInventory("stash", zoneId .. ":" .. crateId) then
			TriggerServerEvent("electus_gangs:openStash", crateId, zoneId)
			exports["ox_inventory"]:openInventory("stash", zoneId .. ":" .. crateId)
		end
	elseif Config.inventory == "qs" or Config.inventory == "tgiann" or Config.inventory == "codem" then
		local other = {}
		other.maxweight = Config.warehouse.weight
		other.slots = Config.warehouse.slots
		TriggerServerEvent("inventory:server:OpenInventory", "stash", zoneId .. ":" .. crateId, other)
		TriggerEvent("inventory:client:SetCurrentStash", zoneId .. ":" .. crateId)
	elseif Config.inventory == "core" or Config.inventory == "qb-inventory" then
		TriggerServerEvent("electus_gangs:openStash", crateId, zoneId)
	else
		local other = {}
		other.maxweight = Config.warehouse.weight
		other.slots = Config.warehouse.slots
		TriggerServerEvent("inventory:server:OpenInventory", "stash", zoneId .. ":" .. crateId, other)
		TriggerEvent("inventory:client:SetCurrentStash", zoneId .. ":" .. crateId)
	end
end

if Config.ui.enterZone.currentZoneCommand and Config.ui.enterZone.enablePopup then
	RegisterCommand(Config.ui.enterZone.currentZoneCommand, function(source, args, raw)
		local zoneId = GetPlayerZone()?.id

		local owner = lib.callback.await("electus_gangs:getGangFromZoneId", false, zoneId)

		if owner then
			SendReactMessage("enteredZone", {
				color = owner.color,
				name = owner.name,
			})
		end
	end)
end

function IsDead()
	local playerPed = PlayerPedId()
	return GetEntityHealth(playerPed) <= 0 or IsPedDeadOrDying(playerPed, true) or IsPlayerDead(playerPed)
end
